<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function admin()
    {
        return $this->belongsTo('Employee', 'admin_id');
    }

    public function booking()
    {
        return $this->hasOne('Booking', 'booking_id');
    }

    public function subscription()
    {
        return $this->belongsTo('Subscription', 'subscription_id');
    }

}